# データの読み込み
import pandas as pd
url = 'https://www.salesanalytics.co.jp/h3lk'
train = pd.read_csv(url)

# グラフ
import altair as alt

fig = alt.Chart(train).mark_bar(size=60).encode(
		x='Survived:O',
		y='count()',
		column=alt.Column('Pclass')
	).properties(
		width=150,
		height=150
	).interactive()

# アプリ
import streamlit as st

## タイトルなど
st.write("""
	# My Web Application
	## This app was created by me!
	This app is a sample of the user interface.
""")

## グラフ表示
st.subheader('Titanic Graph')
st.write(fig)

## データセット表示
st.subheader('Titanic dataset')
st.table(train.head(10))
