# 基本ライブラリー
import numpy as np
import pandas as pd

# データの読み込み
url = 'https://www.salesanalytics.co.jp/h3lk'
train = pd.read_csv(url)

# 予測モデル構築
from sklearn.linear_model import LogisticRegression

logreg = LogisticRegression()
train_X = train[['Fare']]
train_y = train[['Survived']]
logreg.fit(train_X, train_y)

# アプリ
import streamlit as st

## タイトルなど
st.write("""
	# My Web Application
	## This app was created by me!
	This app is a sample of the user interface.
""")

## 生存確率予測　入力→予測器→出力
st.subheader('Survival Probability')

### 入力（スライダー）
minValue = int(np.floor(train['Fare'].min()))
maxValue = int(np.ceil(train['Fare'].max()))
startValue =int((maxValue+minValue)/2)
fareVlue = st.slider('Please select fare', min_value=minValue, max_value=maxValue, step=1, value=startValue)
fareVlue_df = pd.DataFrame([fareVlue], columns=['Fare'])

### 予測器（ロジスティック回帰）
pred_probs = logreg.predict_proba(fareVlue_df)

### 出力（テキスト）
st.write('Survival Probability:',pred_probs[0,1])
