# 基本ライブラリー
import numpy as np
import pandas as pd

# データセット
## データの読み込み
url = 'https://www.salesanalytics.co.jp/h3lk'
train = pd.read_csv(url)

## 欠測値補完
from sklearn.impute import SimpleImputer
mean_imputer = SimpleImputer(strategy='mean')
train[['Age']] = mean_imputer.fit_transform(train[['Age']])

# 予測モデル構築
from sklearn.linear_model import LogisticRegression

logreg = LogisticRegression()
train_X = train[['Pclass','Age','Fare']]
train_y = train[['Survived']]
logreg.fit(train_X, train_y)

# アプリ
import streamlit as st

## サイドパネル（インプット部）
st.sidebar.header('Input Features')

### Pclass入力（ラジオボタン）
pclassValue = st.sidebar.radio('Pclass',(1, 2, 3))

### Age入力（スライドバー）
minValue_age = int(np.floor(train['Age'].min()))
maxValue_age = int(np.ceil(train['Age'].max()))
startValue_age =int((maxValue_age+minValue_age)/2)
ageValue = st.sidebar.slider('Age', min_value=minValue_age, max_value=maxValue_age, step=1, value=startValue_age)

### Fare入力（スライドバー）
minValue = int(np.floor(train['Fare'].min()))
maxValue = int(np.ceil(train['Fare'].max()))
startValue =int((maxValue+minValue)/2)
fareValue = st.sidebar.slider('Fare', min_value=minValue, max_value=maxValue, step=1, value=startValue)

## メインパネル（アウトプット部）
st.write("""
	## Survival Probability
""")

### インプットデータ（1行のデータフレーム生成）
value_df = pd.DataFrame([],columns=['Pclass', 'Age','Fare'])
record = pd.Series([pclassValue, ageValue, fareValue], index=value_df.columns)
value_df = value_df.append(record, ignore_index=True)

### 予測
pred_probs = logreg.predict_proba(value_df)

### 結果出力
st.write(pred_probs[0,1])
