# データの読み込み
import pandas as pd
url = 'https://www.salesanalytics.co.jp/h3lk'
train = pd.read_csv(url)

# グラフ
import altair as alt

## グラフ1
fig = alt.Chart(train).mark_bar(size=60).encode(
		x='Survived:O',
		y='count()',
		column=alt.Column('Pclass')
	).properties(
		width=150,
		height=150
	).interactive()

## グラフ2
fig2 = alt.Chart(train).mark_bar(size=60).encode(
		x='Survived:O',
		y='mean(Age)',
		column=alt.Column('Pclass')
	).properties(
		width=150,
		height=150
	).interactive()

## グラフ3
fig3 = alt.Chart(train).mark_bar(size=60).encode(
		x='Survived:O',
		y='mean(Fare)',
		column=alt.Column('Pclass')
	).properties(
		width=150,
		height=150
	).interactive()

# アプリ
import streamlit as st

## タイトルなど
st.write("""
	# My Web Application
	## This app was created by me!
	This app is a sample of the user interface.
""")

## グラフ表示
st.subheader('Titanic Graph')
submit = st.button('Graph Display')
if submit == True:
	st.write(fig)
	st.write(fig2)
	st.write(fig3)

## データセット表示
st.subheader('Titanic dataset')
st.table(train.head(10))
